<?php
$pageTitle = 'Statistiques';
require_once 'config.php';

$gs = getGsPdo();
$ls = getLsPdo();

global $SERVER_NAME;

$accountsCount = 0;
$onlineCount   = 0;
$charsCount    = 0;
$clansCount    = 0;

try {
    $accountsCount = $ls->query("SELECT COUNT(*) FROM accounts")->fetchColumn();
} catch (Exception $e) {}

try {
    $onlineCount = $gs->query("SELECT COUNT(*) FROM characters WHERE online = 1")->fetchColumn();
} catch (Exception $e) {}

try {
    $charsCount = $gs->query("SELECT COUNT(*) FROM characters")->fetchColumn();
} catch (Exception $e) {}

try {
    $clansCount = $gs->query("SELECT COUNT(*) FROM clan_data")->fetchColumn();
} catch (Exception $e) {}

include 'includes/header.php';
?>

<!-- Bandeau visuel Lineage 2 HF -->
<div class="card">
    <div style="border-radius:1rem;overflow:hidden;border:1px solid #1f2937;">
        <!-- Mets ici un beau panorama du monde HF -->
        <!-- <img src="assets/hf-world-1.jpg" alt="Panorama Lineage 2 High Five" style="width:100%;display:block;max-height:260px;object-fit:cover;"> -->
        <div style="
            width:100%;
            height:220px;
            background:url('assets/hf-world-1.jpg') center/cover no-repeat;
        "></div>
    </div>
</div>

<div class="card">
    <h1 class="page-title">📊 Statistiques serveur</h1>
    <p class="page-intro">
        Un aperçu en temps réel de l'univers <?= htmlspecialchars($SERVER_NAME) ?>.
    </p>

    <!-- Mini galerie thématique HF -->
    <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(180px,1fr));gap:0.7rem;margin-bottom:0.9rem;">
        <div style="border-radius:0.9rem;overflow:hidden;border:1px solid #1f2937;min-height:110px;position:relative;">
            <!-- <img src="assets/hf-city-1.jpg" alt="Ville & hub principal" style="width:100%;height:100%;object-fit:cover;display:block;"> -->
            <div style="position:absolute;left:0.6rem;bottom:0.5rem;background:rgba(3,7,18,0.8);border-radius:999px;padding:0.15rem 0.55rem;font-size:0.75rem;border:1px solid rgba(148,163,184,0.6);">
                Ville & hub
            </div>
        </div>
        <div style="border-radius:0.9rem;overflow:hidden;border:1px solid #1f2937;min-height:110px;position:relative;">
            <!-- <img src="assets/hf-raid-1.jpg" alt="Raid & boss" style="width:100%;height:100%;object-fit:cover;display:block;"> -->
            <div style="position:absolute;left:0.6rem;bottom:0.5rem;background:rgba(3,7,18,0.8);border-radius:999px;padding:0.15rem 0.55rem;font-size:0.75rem;border:1px solid rgba(148,163,184,0.6);">
                Raids & boss
            </div>
        </div>
        <div style="border-radius:0.9rem;overflow:hidden;border:1px solid #1f2937;min-height:110px;position:relative;">
            <!-- <img src="assets/hf-battle-1.jpg" alt="Combat PVP/PVE" style="width:100%;height:100%;object-fit:cover;display:block;"> -->
            <div style="position:absolute;left:0.6rem;bottom:0.5rem;background:rgba(3,7,18,0.8);border-radius:999px;padding:0.15rem 0.55rem;font-size:0.75rem;border:1px solid rgba(148,163,184,0.6);">
                Combat
            </div>
        </div>
    </div>

    <div class="stat-grid">
        <div class="stat-card">
            <div class="stat-label">Comptes (LoginServer)</div>
            <div class="stat-value"><?= (int)$accountsCount ?></div>
        </div>
        <div class="stat-card">
            <div class="stat-label">Personnages</div>
            <div class="stat-value"><?= (int)$charsCount ?></div>
        </div>
        <div class="stat-card">
            <div class="stat-label">Joueurs en ligne</div>
            <div class="stat-value"><?= (int)$onlineCount ?></div>
        </div>
        <div class="stat-card">
            <div class="stat-label">Clans</div>
            <div class="stat-value"><?= (int)$clansCount ?></div>
        </div>
    </div>

    <h2 style="margin-top:1.4rem;">🔍 Découvrir <?= htmlspecialchars($SERVER_NAME) ?></h2>
    <p class="muted">
        Accède rapidement aux pages principales liées à ton univers.
    </p>
    <p style="margin-top:0.4rem;">
        <a class="button-link" href="players_online.php">Voir les joueurs en ligne</a>
        <a class="button-link" href="ls_accounts.php">Comptes & emails LS</a>
        <a class="button-link" href="register.php">Créer un compte</a>
    </p>
</div>
<?php include 'includes/footer.php'; ?>
