<?php
$pageTitle = 'Présentation de ' . ($SERVER_NAME ?? 'Thanys');
require_once 'config.php';
include 'includes/header.php';
?>
<div class="card" style="font-size:1.08rem; line-height:1.7;">
    
    <!-- HERO -->
    <div style="
        border-radius:1.25rem;
        overflow:hidden;
        border:1px solid rgba(148,163,184,0.45);
        margin-bottom:1.6rem;
        background:
            radial-gradient(circle at top left, rgba(56,189,248,0.28), transparent 55%),
            radial-gradient(circle at bottom right, rgba(59,130,246,0.23), transparent 55%),
            #020617;
        box-shadow:0 24px 55px rgba(15,23,42,0.9);
        position:relative;
    ">
        <!-- Fond image -->
        <div style="
            position:absolute;
            inset:0;
            background:url('assets/thanys-hero.jpg') center/cover no-repeat;
            opacity:0.25;
            filter:saturate(1.1);
        "></div>
        <!-- Voile sombre -->
        <div style="
            position:absolute;
            inset:0;
            background:radial-gradient(circle at top, rgba(15,23,42,0.4), rgba(15,23,42,0.96));
        "></div>

        <div style="position:relative;padding:1.6rem 1.7rem 1.5rem 1.7rem;">
            <div style="display:flex;flex-wrap:wrap;gap:1.6rem;align-items:center;justify-content:space-between;">
                <div style="flex:1 1 280px;min-width:260px;">
                    <div style="display:inline-flex;align-items:center;gap:0.5rem;
                                padding:0.32rem 0.8rem;border-radius:999px;
                                border:1px solid rgba(56,189,248,0.75);
                                background:rgba(15,23,42,0.9);
                                font-size:0.78rem;text-transform:uppercase;
                                letter-spacing:0.18em;margin-bottom:0.8rem;
                                opacity:0.95;">
                        <span style="width:8px;height:8px;border-radius:999px;background:#22c55e;
                                     box-shadow:0 0 12px rgba(34,197,94,0.9);"></span>
                        <span>Serveur privé Lineage II – PvE • PvP • RP</span>
                    </div>

                    <h1 class="page-title" style="margin-bottom:0.5rem;font-size:1.9rem;">
                        <?= htmlspecialchars($SERVER_NAME ?? 'Thanys') ?><br>
                        <span style="font-size:1.2rem;font-weight:400;opacity:0.9;">
                            Le serveur PvE qui aime aussi le PvP organisé ⚔️
                        </span>
                    </h1>

                    <p class="muted" style="margin-top:0.4rem;margin-bottom:0.7rem;font-size:1.08rem;">
                        <strong><?= htmlspecialchars($SERVER_NAME ?? 'Thanys') ?></strong>, c’est un serveur avant tout
                        <strong>orienté PvE</strong> : progression, exploration, farm entre amis, quêtes et chill.  
                        Mais quand vient le moment de se mettre des baffes, <strong>le PvP prend le relais</strong> :
                        événements organisés, affrontements encadrés et combats épiques à heure fixe.
                    </p>

                    <p class="muted" style="margin-bottom:1rem;font-size:1.08rem;">
                        Nous laissons aussi une <strong>communauté RP</strong> se développer librement :  
                        si tu aimes donner vie à ton personnage, raconter une histoire et monter un clan avec une vraie identité,
                        tu es au bon endroit ✨
                    </p>

                    <div style="display:flex;flex-wrap:wrap;gap:0.7rem;margin-top:0.4rem;">
                        <!-- BOUTON 1 : outline neutre -->
                        <a href="guide.php"
                           style="
                                display:inline-flex;
                                align-items:center;
                                gap:0.5rem;
                                padding:0.55rem 1.5rem;
                                border-radius:999px;
                                font-size:0.8rem;
                                text-transform:uppercase;
                                letter-spacing:0.13em;
                                font-weight:600;
                                background:transparent;
                                border:1px solid rgba(148,163,184,0.9);
                                text-decoration:none;
                                color:#e5e7eb;
                           ">
                            <span>guide de connexion</span>
                            <span>🚀</span>
                        </a>

                        <!-- BOUTON 2 : outline neutre -->
                        <a href="inscription.php"
                           style="
                                display:inline-flex;
                                align-items:center;
                                gap:0.45rem;
                                padding:0.5rem 1.4rem;
                                border-radius:999px;
                                font-size:0.78rem;
                                text-transform:uppercase;
                                letter-spacing:0.12em;
                                font-weight:500;
                                background:transparent;
                                border:1px solid rgba(148,163,184,0.9);
                                text-decoration:none;
                                color:#e5e7eb;
                           ">
                            <span>créer un compte</span>
                            <span>➜</span>
                        </a>
                    </div>
                </div>

                <!-- Image côté droit -->
                <div style="flex:0 0 auto;max-width:270px;">
                    <div style="
                        border-radius:1rem;
                        overflow:hidden;
                        border:1px solid rgba(15,23,42,0.95);
                        background:#020617;
                        box-shadow:0 20px 45px rgba(15,23,42,1);
                    ">
                        <img src="assets/thanys-illustration-pve.jpg"
                             alt="Ambiance PvE sur <?= htmlspecialchars($SERVER_NAME ?? 'Thanys') ?>"
                             style="width:100%;height:100%;object-fit:cover;display:block;">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- SECTION : THANYs, C'EST QUOI ? -->
    <div style="margin-bottom:1.4rem;">
        <div style="
            border-radius:1.1rem;
            border:1px solid rgba(148,163,184,0.35);
            padding:1.4rem 1.6rem;
            background:
                radial-gradient(circle at top left, rgba(56,189,248,0.12), transparent 55%),
                #020617;
            box-shadow:0 16px 40px rgba(15,23,42,0.9);
        ">
            <div style="display:flex;flex-wrap:wrap;gap:1.5rem;align-items:flex-start;justify-content:space-between;">
                <div style="flex:1 1 280px;min-width:260px;">
                    <h2 style="margin-top:0;margin-bottom:0.5rem;font-size:1.5rem;">
                        <span style="margin-right:0.4rem;">🌌</span>
                        <?= htmlspecialchars($SERVER_NAME ?? 'Thanys') ?>, c’est quoi ?
                    </h2>
                    <p class="muted" style="margin-bottom:0.6rem;font-size:1.08rem;">
                        C’est un serveur pensé pour ceux qui aiment <strong>farmer tranquille</strong>,
                        avancer à leur rythme, optimiser leur personnage… tout en gardant la possibilité
                        de <strong>se frotter aux autres</strong> quand l’envie de PvP se fait sentir.
                    </p>
                    <ul class="muted" style="margin-left:1.1rem;margin-bottom:0.65rem;font-size:1.08rem;">
                        <li style="margin-bottom:0.35rem;">
                            <strong>PvE au cœur du gameplay</strong> : progression, équipements, instances, farm en solo ou en groupe.
                        </li>
                        <li style="margin-bottom:0.35rem;">
                            <strong>PvP organisé</strong> : événements, tournois, zones dédiées, soirées spéciales annoncées à l’avance.
                        </li>
                        <li style="margin-bottom:0.35rem;">
                            <strong>RP friendly</strong> : noms cohérents encouragés, clans à thème, events RP possibles.
                        </li>
                    </ul>
                    <p class="muted" style="font-size:1.08rem;">
                        L’objectif : un serveur <strong>stable</strong>, <strong>lisible</strong>, sans prise de tête,
                        où tu peux te connecter après le boulot, avancer un peu… ou rester toute la nuit à tryhard avec ta guilde 🔥
                    </p>
                </div>

                <div style="flex:0 0 auto;max-width:260px;">
                    <div style="
                        border-radius:1rem;
                        overflow:hidden;
                        border:1px solid rgba(30,64,175,0.9);
                        background:#020617;
                    ">
                        <img src="assets/thanys-pve-pvp.jpg"
                             alt="PvE et PvP sur <?= htmlspecialchars($SERVER_NAME ?? 'Thanys') ?>"
                             style="width:100%;height:100%;object-fit:cover;display:block;">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- SECTION : QUI SOMMES-NOUS ? -->
    <div style="margin-bottom:1.4rem;">
        <div style="
            border-radius:1.1rem;
            border:1px solid rgba(148,163,184,0.35);
            padding:1.4rem 1.6rem;
            background:
                radial-gradient(circle at top left, rgba(34,197,94,0.16), transparent 55%),
                #020617;
            box-shadow:0 16px 40px rgba(15,23,42,0.9);
        ">
            <div style="display:flex;flex-wrap:wrap;gap:1.5rem;align-items:flex-start;justify-content:space-between;">
                <div style="flex:1 1 280px;min-width:260px;">
                    <h2 style="margin-top:0;margin-bottom:0.5rem;font-size:1.5rem;">
                        <span style="margin-right:0.4rem;">🧑‍💻</span>
                        Qui sommes-nous ?
                    </h2>
                    <p class="muted" style="margin-bottom:0.55rem;font-size:1.08rem;">
                        Nous sommes une petite équipe de <strong>développeurs passionnés</strong>, joueurs avant tout,
                        qui en ont eu marre des projets abandonnés, des traductions à moitié finies et des serveurs sans identité.
                    </p>
                    <p class="muted" style="margin-bottom:0.55rem;font-size:1.08rem;">
                        Sur <?= htmlspecialchars($SERVER_NAME ?? 'Thanys') ?>, notre obsession c’est la
                        <strong>qualité de l’expérience de jeu</strong> :
                    </p>
                    <ul class="muted" style="margin-left:1.1rem;margin-bottom:0.65rem;font-size:1.08rem;">
                        <li style="margin-bottom:0.35rem;">
                            Client <strong>déjà entièrement traduit</strong> en français ✅
                        </li>
                        <li style="margin-bottom:0.35rem;">
                            Objectif : <strong>la totalité du serveur</strong> (quêtes, PNJ, systèmes, messages) en français.
                        </li>
                        <li style="margin-bottom:0.35rem;">
                            Corrections régulières, ajustements de confort et suivi des retours de la communauté.
                        </li>
                    </ul>
                    <p class="muted" style="font-size:1.08rem;">
                        On ne promet pas la lune, mais on promet d’être <strong>présents</strong>,
                        <strong>à l’écoute</strong> et de faire évoluer le serveur avec vous, pas contre vous.
                    </p>
                </div>

                <div style="flex:0 0 auto;max-width:260px;">
                    <div style="
                        border-radius:1rem;
                        overflow:hidden;
                        border:1px solid rgba(22,163,74,0.9);
                        background:#020617;
                    ">
                        <img src="assets/thanys-dev-team.jpg"
                             alt="Équipe de développeurs passionnés"
                             style="width:100%;height:100%;object-fit:cover;display:block;">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- SECTION : MATÉRIEL SERVEUR -->
    <div style="margin-bottom:1.4rem;">
        <div style="
            border-radius:1.1rem;
            border:1px solid rgba(148,163,184,0.35);
            padding:1.4rem 1.6rem;
            background:
                radial-gradient(circle at top left, rgba(59,130,246,0.16), transparent 55%),
                #020617;
            box-shadow:0 16px 40px rgba(15,23,42,0.9);
        ">
            <div style="display:flex;flex-wrap:wrap;gap:1.5rem;align-items:flex-start;justify-content:space-between;">
                <div style="flex:1 1 280px;min-width:260px;">
                    <h2 style="margin-top:0;margin-bottom:0.5rem;font-size:1.5rem;">
                        <span style="margin-right:0.4rem;">🖥️</span>
                        Un vrai serveur dédié, pas un jouet
                    </h2>
                    <p class="muted" style="margin-bottom:0.55rem;font-size:1.08rem;">
                        <?= htmlspecialchars($SERVER_NAME ?? 'Thanys') ?> tourne sur un <strong>serveur dédié HP Z4 G4</strong>
                        (pas un simple petit VPS partagé).  
                        L’idée est simple : <strong>stabilité</strong>, <strong>réactivité</strong> et <strong>confort de jeu</strong>.
                    </p>
                    <p class="muted" style="margin-bottom:0.55rem;font-size:1.08rem;">
                        Concrètement, ça veut dire :
                    </p>
                    <ul class="muted" style="margin-left:1.1rem;margin-bottom:0.65rem;font-size:1.08rem;">
                        <li style="margin-bottom:0.35rem;">
                            Ressources dédiées au serveur de jeu, pas d’hébergement mutualisé.
                        </li>
                        <li style="margin-bottom:0.35rem;">
                            Meilleure stabilité en période de rush (events, soirs & week-ends).
                        </li>
                        <li style="margin-bottom:0.35rem;">
                            Un environnement pensé pour accueillir <strong>une vraie communauté</strong>, pas juste quelques tests.
                        </li>
                    </ul>
                    <p class="muted" style="font-size:1.08rem;">
                        Parce qu’un bon serveur, ce n’est pas que du code : c’est aussi une
                        <strong>infrastructure solide</strong> derrière.
                    </p>
                </div>

                <div style="flex:0 0 auto;max-width:260px;">
                    <div style="
                        border-radius:1rem;
                        overflow:hidden;
                        border:1px solid rgba(37,99,235,0.9);
                        background:#020617;
                    ">
                        <img src="assets/thanys-hardware.jpg"
                             alt="Serveur dédié HP Z4 G4"
                             style="width:100%;height:100%;object-fit:cover;display:block;">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- SECTION : RÈGLES DU SERVEUR -->
    <div style="margin-bottom:0.6rem;">
        <div style="
            border-radius:1.1rem;
            border:1px solid rgba(148,163,184,0.35);
            padding:1.4rem 1.6rem;
            background:
                radial-gradient(circle at top left, rgba(248,113,113,0.13), transparent 55%),
                #020617;
            box-shadow:0 16px 40px rgba(15,23,42,0.9);
        ">
            <h2 style="margin-top:0;margin-bottom:0.6rem;font-size:1.5rem;">
                <span style="margin-right:0.4rem;">⚖️</span>
                Règles du serveur
            </h2>
            <p class="muted" style="margin-bottom:0.55rem;font-size:1.08rem;">
                On veut une ambiance <strong>saine</strong>, <strong>fun</strong> et <strong>respectueuse</strong>.
                Les règles ne sont pas là pour brider le jeu, mais pour protéger la communauté.
            </p>

            <ul class="muted" style="margin-left:1.1rem;margin-bottom:0.65rem;font-size:1.08rem;">
                <li style="margin-bottom:0.35rem;">
                    <strong>Respect avant tout</strong> : pas d’insultes, de harcèlement, de propos discriminatoires.
                </li>
                <li style="margin-bottom:0.35rem;">
                    <strong>Cheat / bot / exploit interdits</strong> : utilisation de logiciels tiers ou abus de bugs
                    = sanctions pouvant aller jusqu’au bannissement définitif.
                </li>
                <li style="margin-bottom:0.35rem;">
                    <strong>Serveur à dominante PvE, PvP organisé</strong> : le cœur du jeu reste le <strong>PvE</strong> et le farm tranquille.
                    Des <strong>périodes PvP</strong> pourront être ouvertes sur des créneaux précis (events, soirées spéciales, zones dédiées)
                    et seront <strong>toujours annoncées à l’avance</strong> (site / Discord) afin que chacun sache à quoi s’attendre
                    et puisse choisir de participer ou non.
                </li>
                <li style="margin-bottom:0.35rem;">
                    <strong>RP bienvenu, pas obligatoire</strong> : si tu joues RP, respecte ceux qui n’en font pas,
                    et inversement.
                </li>
                <li style="margin-bottom:0.35rem;">
                    <strong>Pseudos & noms de clans</strong> : évite les noms offensants, racistes, sexuels ou clairement hors univers.
                </li>
            </ul>

            <p class="muted" style="margin-bottom:0.4rem;font-size:1.08rem;">
                En cas de doute ou de problème, le staff reste disponible : le but est que
                <strong>tout le monde prenne du plaisir à jouer</strong>, que tu sois tryhard, casual, PvE only,
                amateur de PvP ou gros joueur RP.
            </p>

            <div style="margin-top:0.7rem;">
                <!-- BOUTON BAS : neutre / outline -->
                <a href="guide.php"
                   style="
                        display:inline-flex;
                        align-items:center;
                        gap:0.45rem;
                        padding:0.55rem 1.5rem;
                        border-radius:999px;
                        font-size:0.8rem;
                        text-transform:uppercase;
                        letter-spacing:0.13em;
                        font-weight:600;
                        background:transparent;
                        border:1px solid rgba(148,163,184,0.9);
                        text-decoration:none;
                        color:#e5e7eb;
                   ">
                    <span>rejoindre l’aventure</span>
                    <span>🔥</span>
                </a>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>



