<?php
$pageTitle = 'Joueurs en ligne';
require_once 'config.php';

$gs = getGsPdo();

// Nombre de joueurs en ligne
$onlineCount = 0;
$players = [];

try {
    $onlineCount = (int)$gs->query("SELECT COUNT(*) FROM characters WHERE online = 1")->fetchColumn();

    $stmt = $gs->query("
        SELECT char_name, level
        FROM characters
        WHERE online = 1
        ORDER BY level DESC, char_name ASC
        LIMIT 200
    ");
    $players = $stmt->fetchAll();
} catch (Exception $e) {
    // En cas d'erreur DB, on laisse vide et on peut afficher un message
}

include 'includes/header.php';
?>

<!-- Bandeau visuel HF pour la page joueurs en ligne -->
<div class="card">
    <div style="border-radius:1rem;overflow:hidden;border:1px solid #1f2937;">
        <!-- <img src="assets/hf-battle-1.jpg" alt="Combats Lineage 2 High Five" style="width:100%;display:block;max-height:260px;object-fit:cover;"> -->
        <div style="
            width:100%;
            height:220px;
            background:url('assets/hf-battle-1.jpg') center/cover no-repeat;
        "></div>
    </div>
</div>

<div class="card">
    <h1 class="page-title">Joueurs en ligne</h1>
    <p class="page-intro">
        Liste des personnages actuellement connectés sur l'univers <?= htmlspecialchars($SERVER_NAME) ?>.
    </p>

    <div class="stat-grid" style="margin-bottom:1rem;">
        <div class="stat-card">
            <div class="stat-label">Joueurs en ligne</div>
            <div class="stat-value"><?= (int)$onlineCount ?></div>
        </div>
    </div>

    <?php if ($onlineCount <= 0 || empty($players)): ?>
        <p class="muted">
            Aucun joueur n'est connecté pour le moment. Revenez un peu plus tard, ou rassemblez vos amis pour envahir Aden !
        </p>
    <?php else: ?>
        <table style="width:100%;border-collapse:collapse;font-size:0.9rem;margin-top:0.5rem;">
            <thead>
                <tr style="border-bottom:1px solid #1f2937;">
                    <th style="text-align:left;padding:0.35rem 0.4rem;color:#9ca3af;">Nom</th>
                    <th style="text-align:left;padding:0.35rem 0.4rem;color:#9ca3af;">Niveau</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach ($players as $p): ?>
                <tr style="border-bottom:1px solid #111827;">
                    <td style="padding:0.3rem 0.4rem;"><?= htmlspecialchars($p['char_name']) ?></td>
                    <td style="padding:0.3rem 0.4rem;"><?= (int)$p['level'] ?></td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>

<?php include 'includes/footer.php'; ?>
