<?php
$pageTitle = 'Accueil';
require_once 'config.php';

$gs = getGsPdo();
$ls = getLsPdo();

// Status serveurs
$lsOnline = isServerOnline($LS_STATUS_HOST, $LS_STATUS_PORT);
$gsOnline = isServerOnline($GS_STATUS_HOST, $GS_STATUS_PORT);

// Joueurs en ligne
$onlineCount = 0;
try {
    $onlineCount = $gs->query("SELECT COUNT(*) FROM characters WHERE online = 1")->fetchColumn();
} catch (Exception $e) {}

include 'includes/header.php';
?>

<div class="card">
    <div class="hero-grid">
        <div>
            <p class="muted">Serveur privé Lineage 2 High Five • FR</p>
            <h1 class="hero-title">Entrez dans l'ère <span class="highlight"><?= htmlspecialchars($SERVER_NAME) ?></span>.</h1>
            <p class="hero-subtitle">
                Un univers sombre, nerveux et exigeant, inspiré de l'esprit original de Lineage 2, pensé pour les joueurs qui aiment
                le farm, la stratégie et les fights propres.
            </p>
            <div class="hero-meta">
                <span class="pill">Chronicle : High Five (CT2.6)</span>
                <span class="pill">Client FR recommandé</span>
                <span class="pill"><?= (int)$onlineCount ?> joueurs en ligne</span>
            </div>
            <div class="button-row">
                <a href="guide.php" class="button-link btn-primary">Rejoindre le serveur</a>
                <a href="#" class="button-link btn-ghost">Télécharger le client FR</a>
            </div>
        </div>
        <div class="hero-art">
            <div class="hero-art-placeholder"></div>
            <div class="hero-status-bar">
                <div>
                    <span class="pill">Univers <?= htmlspecialchars($SERVER_NAME) ?></span>
                </div>
                <div>
                    <span class="status-pill">
                        <span class="status-dot <?= $lsOnline ? 'online' : '' ?>"></span>
                        <span class="status-label">Login</span>
                    </span>
                    &nbsp;&nbsp;
                    <span class="status-pill">
                        <span class="status-dot <?= $gsOnline ? 'online' : '' ?>"></span>
                        <span class="status-label">Game</span>
                    </span>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <h1 class="page-title">Bienvenue dans l'univers <?= htmlspecialchars($SERVER_NAME) ?></h1>
    <p class="page-intro">
        <?= htmlspecialchars($SERVER_NAME) ?> est un serveur privé Lineage 2 High Five (CT2.6) entièrement pensé pour les joueurs FR :
        atmosphère sombre, progression nerveuse, PVE solide et PVP propre. Ici, tu retrouves l'essence de Lineage 2, avec une touche moderne.
    </p>

    <h2>✨ Lineage 2 High Five, c'est quoi&nbsp;?</h2>
    <p class="muted">
        High Five est l'une des dernières grandes chronicles "classiques" de Lineage 2 : un mélange parfait entre difficulté, profondeur de gameplay
        et possibilités de builds. Une méta riche, des classes emblématiques, des instances exigeantes et un endgame PVP/PVE qui récompense les joueurs investis.
    </p>

    <h2 style="margin-top:1.4rem;">⚔ L'expérience <?= htmlspecialchars($SERVER_NAME) ?></h2>
    <div class="stat-grid">
        <div class="stat-card">
            <div class="stat-label">Progression &amp; leveling</div>
            <div class="stat-value" style="font-size:1rem;">
                Rythme équilibré
            </div>
            <p class="muted" style="margin-top:0.3rem;">
                Une montée en niveau dynamique mais sans tuer le plaisir du farm. Tu as le temps de découvrir tes skills, ton perso,
                et les zones emblématiques d'Aden sans te sentir bridé.
            </p>
        </div>
        <div class="stat-card">
            <div class="stat-label">PVE &amp; instances</div>
            <div class="stat-value" style="font-size:1rem;">
                Donjons retravaillés
            </div>
            <p class="muted" style="margin-top:0.3rem;">
                Instances et spots ajustés pour rendre le PVE intéressant à haut niveau : meilleurs rewards, mécaniques plus lisibles,
                et un vrai intérêt à jouer en groupe.
            </p>
        </div>
        <div class="stat-card">
            <div class="stat-label">PVP &amp; siège</div>
            <div class="stat-value" style="font-size:1rem;">
                PVP propre &amp; lisible
            </div>
            <p class="muted" style="margin-top:0.3rem;">
                L'objectif est un PVP où le placement, la compo de groupe et la coordination font la différence, pas seulement la RNG.
            </p>
        </div>
    </div>

        <h2 style="margin-top:1.4rem;">Galerie &amp; visuels</h2>

    <div class="gallery-grid">
        <div class="gallery-slot">
            <img src="assets/hf-city-1.jpg" alt="Ville principale Lineage 2 HF">
            <div class="gallery-slot-label">Ville / hub principal</div>
        </div>
        <div class="gallery-slot">
            <img src="assets/hf-battle-1.jpg" alt="Combat PVE / PVP">
            <div class="gallery-slot-label">Combat PVE / PVP</div>
        </div>
        <div class="gallery-slot">
            <img src="assets/hf-world-1.jpg" alt="Paysages &amp; zones de farm">
            <div class="gallery-slot-label">Paysages &amp; zones de farm</div>
        </div>
        <div class="gallery-slot">
            <img src="assets/hf-raid-1.jpg" alt="Raid / boss épique">
            <div class="gallery-slot-label">Raid &amp; boss</div>
        </div>
    </div>


    <h2 style="margin-top:1.4rem;">🚀 Comment nous rejoindre&nbsp;?</h2>
    <p style="margin-top:0.4rem;">
        <a href="register.php" class="button-link btn-primary">Créer un compte</a>
        <a href="guide.php" class="button-link btn-ghost">Voir le guide d'installation</a>
    </p>
</div>

<?php include 'includes/footer.php'; ?>
