<?php // includes/header.php ?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title><?= isset($pageTitle) ? htmlspecialchars($pageTitle) . ' - ' : '' ?><?= htmlspecialchars($SERVER_NAME) ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Police médiévale lisible -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@500;700;900&display=swap" rel="stylesheet">

    <style>
        :root {
            --bg-main: #020617;
            --bg-card: #020617;
            --bg-elevated: #020617;
            --border-subtle: #1f2937;
            --accent: #38bdf8;
            --accent-soft: rgba(56,189,248,0.12);
            --accent-strong: #38bdf8;
            --text-main: #f3f4f6;
            --text-muted: #cbd5f5;
        }

        * {
            box-sizing: border-box;
        }

        body {
            margin: 0;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            background: radial-gradient(circle at top, #0b1120 0, #020617 50%, #000 100%);
            color: var(--text-main);
        }

        a {
            color: var(--accent);
            text-decoration: none;
        }

        a:hover {
            text-decoration: underline;
        }

        .layout {
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }

        header {
            border-bottom: 1px solid #020617;
            background: linear-gradient(to right, #020617, #020617 35%, #0b1120 100%);
            position: sticky;
            top: 0;
            z-index: 20;
        }

        .header-inner {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0.75rem 1rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 1rem;
        }

        .brand {
            display: flex;
            align-items: center;
            gap: 0.8rem;
        }

        /* Ancien logo "planète" – utilisé pour le footer (ne pas supprimer) */
        .brand-logo {
            position: relative;
            width: 72px;
            height: 72px;
            border-radius: 999px;
            background: radial-gradient(circle at 30% 20%, #38bdf8 0, #0f172a 45%, #020617 80%);
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 800;
            font-size: 1.2rem;
            color: #e5e7eb;
            box-shadow:
                0 0 26px rgba(56,189,248,0.9),
                0 0 42px rgba(251,191,36,0.5);
            overflow: hidden;
        }
        .brand-logo::before {
            content: '';
            position: absolute;
            inset: 24%;
            border-radius: 999px;
            background: linear-gradient(135deg, rgba(15,23,42,0.2), rgba(15,23,42,0.95));
            box-shadow: inset 0 0 16px rgba(15,23,42,1);
        }
        .brand-logo::after {
            content: '';
            position: absolute;
            inset: 52% -32%;
            border-radius: 999px;
            border-top: 3px solid #facc15;
            border-bottom: 3px solid transparent;
            opacity: 0.95;
            transform-origin: 50% 50%;
            animation: orbit-ring 7s linear infinite;
        }
        .brand-logo .orbit-dot {
            position: absolute;
            width: 10px;
            height: 10px;
            border-radius: 999px;
            background: #fbbf24;
            box-shadow: 0 0 18px rgba(250,204,21,0.95);
            animation: orbit-dot 5s linear infinite;
        }

        /* Bloc logo dans le header */
        .brand-main-block {
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            gap: 0.25rem;
        }

        /* Logo large doré pour le header, fond uniforme + encadrement or */
        .brand-logo-image {
            position: relative;
            width: 280px;
            height: 120px;
            border-radius: 1.1rem;
            padding: 8px 14px;
            background: #020617; /* fond uniforme sombre */
            border: 2px solid #facc15; /* encadrement doré net */
            box-shadow:
                0 0 18px rgba(250,204,21,0.75),
                0 0 32px rgba(15,23,42,0.95);
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }

        .brand-logo-image::before {
            content: '';
            position: absolute;
            inset: -10px;
            border-radius: 1.3rem;
            border: 1px solid rgba(250,204,21,0.35);
            box-shadow:
                0 0 26px rgba(250,204,21,0.8),
                0 0 36px rgba(56,189,248,0.45);
            opacity: 0.6;
            pointer-events: none;
        }

        .brand-logo-image img {
            max-width: 100%;
            height: auto;
            display: block;
            filter: drop-shadow(0 0 12px rgba(0,0,0,0.9));
        }

        .brand-text {
            display: flex;
            flex-direction: column;
            gap: 0.1rem;
        }

        /* NAV HEADER – titres plus grands et plus lisibles */
        nav {
            display: flex;
            gap: 0.7rem;
            font-size: 0.95rem;
        }

        nav a {
            padding: 0.35rem 0.9rem;
            border-radius: 999px;
            border: 1px solid transparent;
            color: #e5e7eb;
            text-decoration: none;
            font-weight: 500;
            letter-spacing: 0.06em;
            text-transform: uppercase;
        }

        nav a:hover {
            border-color: rgba(56,189,248,0.9);
            background: rgba(15,23,42,0.9);
            text-decoration: none;
            box-shadow: 0 0 14px rgba(56,189,248,0.6);
        }

        main {
            flex: 1;
            max-width: 1200px;
            margin: 1.2rem auto 2rem;
            padding: 0 1rem;
        }

        .card {
            background: radial-gradient(circle at top, #020617 0, #020617 40%, #020617 100%);
            border-radius: 1.2rem;
            border: 1px solid var(--border-subtle);
            padding: 1.2rem 1.2rem 1rem;
            margin-bottom: 1rem;
            box-shadow: 0 20px 45px rgba(15,23,42,0.75);
        }

        h1 {
            font-size: 2.1rem;
            margin: 0 0 0.75rem;
            color: #e0f2fe;
        }

        h2 {
            font-size: 1.5rem;
            margin-top: 1.5rem;
            margin-bottom: 0.75rem;
            color: #7dd3fc;
        }

        .page-title {
            font-size: 1.9rem;
            margin: 0 0 0.5rem;
            color: #e0f2fe;
            letter-spacing: 0.08em;
            text-transform: uppercase;
        }

        .page-intro {
            font-size: 0.95rem;
            color: var(--text-muted);
            margin-bottom: 0.9rem;
        }

        .muted {
            color: var(--text-muted);
            font-size: 0.9rem;
        }

        .hero-grid {
            display: grid;
            grid-template-columns: minmax(0, 3fr) minmax(0, 2.5fr);
            gap: 1.4rem;
            align-items: stretch;
        }

        .hero-title {
            font-family: 'Cinzel', system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            font-size: 2.4rem;
            line-height: 1.15;
            margin: 0 0 0.6rem;
            letter-spacing: 0.06em;
            text-transform: uppercase;
            color: #f9f9fb;
            text-shadow:
                0.03em 0.03em 0 #020617,
                0 0 14px rgba(15,23,42,0.9);
        }

        .hero-title span.highlight {
            display: inline-block;
            background: linear-gradient(120deg,#22c55e,#38bdf8,#0ea5e9);
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            text-shadow: 0 0 24px rgba(56,189,248,0.9);
        }

        .hero-subtitle {
            font-size: 1.05rem;
            color: #e5e7eb;
            max-width: 36rem;
            opacity: 0.9;
        }

        .hero-meta {
            display: flex;
            flex-wrap: wrap;
            gap: 0.5rem;
            margin: 0.8rem 0 0.8rem;
        }

        .pill {
            padding: 0.18rem 0.55rem;
            border-radius: 999px;
            border: 1px solid rgba(148,163,184,0.6);
            font-size: 0.75rem;
            color: #e5e7eb;
            background: rgba(15,23,42,0.9);
        }

        .button-row {
            display: flex;
            flex-wrap: wrap;
            gap: 0.5rem;
            margin-top: 0.6rem;
        }

        .button-link {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 0.55rem 1.1rem;
            border-radius: 999px;
            font-size: 0.9rem;
            border: 1px solid rgba(148,163,184,0.6);
            background: rgba(15,23,42,0.8);
            color: #e5e7eb;
            text-decoration: none;
            gap: 0.35rem;
            transition: all 0.18s ease-out;
        }

        .button-link:hover {
            transform: translateY(-1px);
            box-shadow: 0 0 16px rgba(56,189,248,0.5);
            border-color: rgba(56,189,248,0.9);
            text-decoration: none;
        }

        .btn-primary {
            background: linear-gradient(135deg,#22c55e,#38bdf8);
            border-color: transparent;
            color: #0b1120;
        }

        .btn-primary:hover {
            box-shadow: 0 0 18px rgba(56,189,248,0.9);
        }

        .btn-ghost {
            background: transparent;
            color: #e5e7eb;
        }

        .hero-art {
            position: relative;
            border-radius: 1.1rem;
            overflow: hidden;
            border: 1px solid rgba(15,23,42,1);
            background:
                radial-gradient(circle at top, rgba(56,189,248,0.3),transparent 50%),
                radial-gradient(circle at bottom, rgba(15,23,42,0.9),#020617 70%);
            min-height: 220px;
            display: flex;
            align-items: stretch;
        }

        .hero-art-placeholder {
            flex: 1;
            background: url('assets/lineage2-hf-hero.jpg') center/cover no-repeat;
            filter: saturate(1.2) contrast(1.05);
        }

        .hero-status-bar {
            position: absolute;
            left: 0.8rem;
            top: 0.8rem;
            right: 0.8rem;
            padding: 0.35rem 0.6rem;
            border-radius: 999px;
            background: rgba(3,7,18,0.85);
            border: 1px solid rgba(31,41,55,0.9);
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 0.5rem;
            font-size: 0.78rem;
        }

        .status-pill {
            display: inline-flex;
            align-items: center;
            gap: 0.3rem;
        }

        .status-dot {
            width: 8px;
            height: 8px;
            border-radius: 999px;
            background: #f97373;
            box-shadow: 0 0 10px rgba(248,113,113,0.5);
        }

        .status-dot.online {
            background: #4ade80;
            box-shadow: 0 0 10px rgba(74,222,128,0.7);
        }

        .status-label {
            color: #e5e7eb;
        }

        .stat-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit,minmax(180px,1fr));
            gap: 0.9rem;
            margin-top: 0.7rem;
        }

        .stat-card {
            border-radius: 0.9rem;
            border: 1px solid var(--border-subtle);
            padding: 0.7rem 0.8rem;
            background: radial-gradient(circle at top, rgba(15,23,42,0.6),#020617);
        }

        .stat-label {
            font-size: 0.8rem;
            color: var(--text-muted);
        }

        .stat-value {
            font-size: 1.1rem;
            font-weight: 600;
            margin-top: 0.2rem;
        }

        .gallery-grid {
            margin-top: 1rem;
            display: grid;
            grid-template-columns: repeat(auto-fit,minmax(220px,1fr));
            gap: 0.9rem;
        }

        .gallery-slot {
            position: relative;
            border-radius: 1rem;
            overflow: hidden;
            border: 1px solid var(--border-subtle);
            background: radial-gradient(circle at top, rgba(15,23,42,0.9), #020617);
            min-height: 140px;
        }

        .gallery-slot img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            display: block;
        }

        .gallery-slot-label {
            position: absolute;
            left: 0.75rem;
            bottom: 0.5rem;
            padding: 0.2rem 0.6rem;
            border-radius: 999px;
            background: rgba(15,23,42,0.85);
            border: 1px solid rgba(148,163,184,0.5);
            font-size: 0.75rem;
            color: #e5e7eb;
        }

        footer {
            text-align: center;
            padding: 1.2rem 0.5rem 1.6rem;
            font-size: 0.8rem;
            color: #6b7280;
            border-top: 1px solid #020617;
            background: #020617;
        }

        .footer-inner {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 1rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 0.75rem;
        }

        .footer-left {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .brand-logo--small {
            transform: scale(0.6);
            transform-origin: left center;
        }

        .footer-brand-text {
            letter-spacing: 0.08em;
            text-transform: uppercase;
            font-weight: 600;
            color: #e5e7eb;
        }

        .footer-copy {
            font-size: 0.78rem;
            color: #9ca3af;
        }

        @keyframes orbit-ring {
            from { transform: rotate(0deg); }
            to   { transform: rotate(360deg); }
        }

        @keyframes orbit-dot {
            from { transform: rotate(0deg) translateX(18px); }
            to   { transform: rotate(360deg) translateX(18px); }
        }

        @media (max-width: 900px) {
            .header-inner {
                flex-direction: column;
                align-items: flex-start;
            }
            nav {
                flex-wrap: wrap;
            }
            .hero-grid {
                grid-template-columns: minmax(0,1fr);
            }
        }
    </style>
</head>
<body>
<div class="layout">
<header>
    <div class="header-inner">
        <div class="brand">
            <div class="brand-main-block">
                <!-- Logo large doré avec fond uniforme et encadrement -->
                <div class="brand-logo-image">
                    <img src="assets/logo-thanys-header.png"
                         alt="THANYS - Lineage 2 High Five">
                </div>
            </div>
        </div>
        <nav>
            <a href="index.php">Accueil</a>
            <a href="monitoring.php">Online</a>
            <a href="Presentation.php">Presentations</a>
            <a href="Maps.php"> Cartes</a>
            <a href="register.php">Inscription</a>
            <a href="guide.php">Guide</a>
            <!-- Pas de lien admin ici, panel caché -->
        </nav>
    </div>
</header>
<main>

