<?php
$pageTitle = 'Guide de connexion';
require_once 'config.php';

// Options dynamiques pour les rates et le nombre de joueurs en ligne.
// À définir dans config.php si tu veux les personnaliser.
$serverRates = $SERVER_RATES ?? [
    'XP'    => 'x1',
    'SP'    => 'x1',
    'ADENA' => 'x1',
    'DROP'  => 'x1'
];
$onlinePlayers = $ONLINE_PLAYERS ?? null;

include 'includes/header.php';
?>

<style>
    /* Boutons du guide : sobres, sans couleur par défaut, néon bleu au survol */
    .guide-btn {
        display: inline-flex;
        align-items: center;
        gap: 0.45rem;
        border-radius: 999px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.11em;
        font-size: 0.78rem;
        line-height: 1;
        text-decoration: none;
        border: 1px solid rgba(148,163,184,0.7);
        background: transparent;
        color: #e5e7eb;
        box-shadow: none;
        transition:
            background 0.18s ease,
            box-shadow 0.18s ease,
            border-color 0.18s ease,
            transform 0.12s ease;
    }

    .guide-btn:hover {
        border-color: rgba(56,189,248,0.95);
        background:
            radial-gradient(circle at 0 0, rgba(56,189,248,0.18), transparent 60%),
            radial-gradient(circle at 100% 100%, rgba(59,130,246,0.18), transparent 55%);
        box-shadow:
            0 0 0 1px rgba(56,189,248,0.6),
            0 0 18px rgba(56,189,248,0.9);
        transform: translateY(-1px);
    }
</style>

<div class="card" style="font-size:1.12rem; line-height:1.65;">
    <h1 class="page-title">🚀 Rejoindre <?= htmlspecialchars($SERVER_NAME) ?></h1>
    
    <!-- Bandeau illustré HF -->
    <div style="border-radius:1rem;overflow:hidden;border:1px solid #1f2937;margin-bottom:1rem;">
        <div style="
            width:100%;
            height:210px;
            background:url('assets/hf-city-1.jpg') center/cover no-repeat;
        "></div>
    </div>

    <!-- SECTION 1 : TÉLÉCHARGER LE CLIENT (cadre stylé avec image de fond) -->
    <div style="margin-bottom:1.4rem;">
        <div style="
            border-radius:1.1rem;
            border:1px solid rgba(148,163,184,0.45);
            padding:1.5rem 1.7rem;
            background:
                radial-gradient(circle at top left, rgba(56,189,248,0.18), transparent 55%),
                radial-gradient(circle at bottom right, rgba(59,130,246,0.16), transparent 55%),
                #020617;
            box-shadow:0 18px 45px rgba(15,23,42,0.95);
            position:relative;
            overflow:hidden;
        ">
            <!-- Image de fond derrière le contenu -->
            <div style="
                position:absolute;
                inset:0;
                background:url('assets/hf-city-1.jpg') center/cover no-repeat;
                opacity:0.25;
                filter:grayscale(100%);
                pointer-events:none;
            "></div>

            <div style="position:relative;z-index:1;">
                <div style="display:flex;flex-wrap:wrap;gap:1.6rem;align-items:center;justify-content:space-between;">
                    <div style="flex:1 1 260px;min-width:260px;">
                        <div style="display:inline-flex;align-items:center;gap:0.4rem;
                                    padding:0.3rem 0.75rem;border-radius:999px;
                                    border:1px solid rgba(56,189,248,0.6);
                                    background:rgba(15,23,42,0.9);
                                    font-size:0.8rem;text-transform:uppercase;
                                    letter-spacing:0.12em;margin-bottom:0.6rem;
                                    opacity:0.9;">
                            <span style="width:7px;height:7px;border-radius:999px;background:#22d3ee;"></span>
                            <span>Étape 1 — Téléchargement du client</span>
                        </div>

                        <h2 style="margin:0 0 0.5rem 0;font-size:1.5rem;display:flex;align-items:center;gap:0.5rem;">
                            <span>📥</span>
                            <span>Télécharger le client</span>
                        </h2>

                        <p class="muted" style="margin-bottom:0.55rem;font-size:1.15rem;">
                            Télécharge le client <strong><?= htmlspecialchars($SERVER_NAME) ?></strong>, installe-le, lance-le…  
                            et tu es en jeu en quelques minutes, sans prise de tête.
                        </p>
                        <p class="muted" style="margin-bottom:0.9rem;font-size:1.15rem;">
                            Serveur <strong>stable</strong>, gameplay <strong>dynamique</strong> et communauté <strong>active</strong> :  
                            si tu veux rejoindre l’aventure, tout commence par ce téléchargement.
                        </p>

                        <!-- BOUTON 1 : sans couleur + néon bleu au survol -->
                        <a href="https://1drv.ms/u/c/dc67ca6cfcae03b1/IQChW9wCdo_6QILNSy-kT0z9Ad5jz4IgM16USRpwSdWtJeY?e=L85Nlm"
                           class="btn btn-primary guide-btn"
                           target="_blank"
                           rel="noopener"
                           style="padding:0.5rem 1.3rem;">
                            <span>télécharger le client</span>
                            <span style="font-size:1.05rem;transform:translateY(1px);">⬇️</span>
                        </a>

                        <p class="muted" style="margin-top:0.7rem;font-size:0.82rem;opacity:0.9;">
                            Téléchargement sécurisé via OneDrive. Prévois quelques Go d’espace disque, installe,  
                            et tu seras prêt à rejoindre <?= htmlspecialchars($SERVER_NAME) ?> dans les meilleures conditions.
                        </p>
                    </div>

                    <!-- Bloc image à droite -->
                    <div style="flex:0 0 auto;max-width:260px;">
                        <div style="
                            position:relative;
                            max-width:260px;
                            margin:0 auto;
                        ">
                            <div style="
                                position:absolute;
                                inset:-2px;
                                border-radius:1.1rem;
                                background:conic-gradient(from 140deg,#22d3ee,#6366f1,#0f172a,#22d3ee);
                                opacity:0.65;
                                filter:blur(6px);
                            "></div>

                            <div style="
                                position:relative;
                                border-radius:1rem;
                                padding:0.22rem;
                                background:radial-gradient(circle at top left,rgba(34,211,238,0.4),rgba(15,23,42,1));
                                box-shadow:0 18px 40px rgba(15,23,42,0.95);
                            ">
                                <div style="
                                    border-radius:0.9rem;
                                    overflow:hidden;
                                    background:#020617;
                                    border:1px solid rgba(15,23,42,0.9);
                                ">
                                    <img src="assets/hf-world-1.jpg"
                                         alt="Univers de <?= htmlspecialchars($SERVER_NAME) ?>"
                                         style="width:100%;height:100%;object-fit:cover;display:block;mix-blend-mode:screen;opacity:0.95;">
                                </div>

                                <div style="
                                    position:absolute;
                                    bottom:0.6rem;
                                    left:0.75rem;
                                    padding:0.28rem 0.6rem;
                                    border-radius:999px;
                                    font-size:0.78rem;
                                    background:rgba(15,23,42,0.9);
                                    border:1px solid rgba(148,163,184,0.7);
                                    display:flex;
                                    align-items:center;
                                    gap:0.35rem;
                                    text-transform:uppercase;
                                    letter-spacing:0.16em;
                                ">
                                    <span style="width:8px;height:8px;border-radius:999px;background:#22c55e;"></span>
                                    <span>client ready to play</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> <!-- /flex -->
            </div> <!-- /relative content -->
        </div> <!-- /cadre -->
    </div>

    <!-- SECTION 2 : INSTALLATION DU JEU (cadre) -->
    <div style="margin-bottom:1.4rem;">
        <div style="
            border-radius:1.1rem;
            border:1px solid rgba(148,163,184,0.35);
            padding:1.5rem 1.7rem;
            background:
                radial-gradient(circle at top left, rgba(56,189,248,0.12), transparent 55%),
                #020617;
            box-shadow:0 14px 35px rgba(15,23,42,0.9);
            position:relative;
            overflow:hidden;
        ">
            <div style="position:absolute;inset:0;pointer-events:none;opacity:0.09;
                        background:radial-gradient(circle at bottom right, rgba(37,99,235,0.45), transparent 60%);">
            </div>

            <div style="position:relative;z-index:1;">
                <div style="display:flex;flex-wrap:wrap;gap:1.5rem;align-items:flex-start;justify-content:space-between;">
                    <div style="flex:1 1 260px;min-width:260px;">
                        <div style="display:inline-flex;align-items:center;gap:0.4rem;
                                    padding:0.26rem 0.7rem;border-radius:999px;
                                    border:1px solid rgba(148,163,184,0.65);
                                    background:rgba(15,23,42,0.95);
                                    font-size:0.8rem;text-transform:uppercase;
                                    letter-spacing:0.11em;margin-bottom:0.5rem;
                                    opacity:0.9;">
                            <span style="width:7px;height:7px;border-radius:999px;background:#38bdf8;"></span>
                            <span>Étape 2 — Installation du jeu</span>
                        </div>

                        <h2 style="margin:0 0 0.5rem 0;font-size:1.5rem;display:flex;align-items:center;gap:0.5rem;">
                            <span>🛠</span>
                            <span>Installation du jeu</span>
                        </h2>

                        <p class="muted" style="font-size:1.15rem;">
                            Après le téléchargement, installe le client tranquillement sur ton PC en suivant ces étapes :
                        </p>
                        <ol class="muted" style="margin-left:1.2rem;margin-top:0.45rem;font-size:1.15rem;">
                            <li>
                                <strong>Décompresse (dézippe) l’archive</strong> téléchargée dans le dossier de ton choix  
                                (par exemple <code>C:\Jeux\<?= htmlspecialchars($SERVER_NAME) ?></code>).
                            </li>
                            <li style="margin-top:0.4rem;">
                                Ouvre le dossier du jeu, puis rends-toi dans le dossier <strong><code>system</code></strong>.
                            </li>
                            <li style="margin-top:0.4rem;">
                                Repère le fichier <strong><code>L2.exe</code></strong>, fais un clic droit dessus puis  
                                <strong>« Envoyer vers &gt; Bureau (créer un raccourci) »</strong>.
                            </li>
                        </ol>
                        <p class="muted" style="margin-top:0.7rem;font-size:1.15rem;">
                            Tu utiliseras ensuite <strong>toujours ce raccourci</strong> sur ton bureau pour lancer le jeu.
                        </p>
                    </div>

                    <!-- Image thème installation -->
                    <div style="flex:0 0 auto;max-width:240px;">
                        <div style="
                            border-radius:0.9rem;
                            overflow:hidden;
                            border:1px solid #1f2937;
                            min-height:150px;
                            background:#020617;
                        ">
                            <img src="assets/hf-install-1.jpg"
                                 alt="Installation du client <?= htmlspecialchars($SERVER_NAME) ?>"
                                 style="width:100%;height:100%;object-fit:cover;display:block;">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- SECTION 3 : CRÉATION DE COMPTE / INSCRIPTION (cadre + état serveur) -->
    <div style="margin-bottom:0.6rem;">
        <div style="
            border-radius:1.1rem;
            border:1px solid rgba(148,163,184,0.35);
            padding:1.5rem 1.7rem;
            background:
                radial-gradient(circle at top left, rgba(56,189,248,0.12), transparent 55%),
                #020617;
            box-shadow:0 14px 35px rgba(15,23,42,0.9);
            position:relative;
            overflow:hidden;
        ">
            <div style="position:absolute;inset:0;pointer-events:none;opacity:0.09;
                        background:radial-gradient(circle at bottom right, rgba(30,64,175,0.75), transparent 60%);">
            </div>

            <div style="position:relative;z-index:1;">
                <div style="display:flex;flex-wrap:wrap;gap:1.5rem;align-items:flex-start;justify-content:space-between;">
                    <!-- Texte inscription obligatoire -->
                    <div style="flex:1 1 260px;min-width:260px;">
                        <div style="display:inline-flex;align-items:center;gap:0.4rem;
                                    padding:0.26rem 0.7rem;border-radius:999px;
                                    border:1px solid rgba(148,163,184,0.65);
                                    background:rgba(15,23,42,0.95);
                                    font-size:0.8rem;text-transform:uppercase;
                                    letter-spacing:0.11em;margin-bottom:0.5rem;
                                    opacity:0.9;">
                            <span style="width:7px;height:7px;border-radius:999px;background:#22c55e;"></span>
                            <span>Étape 3 — Inscription obligatoire</span>
                        </div>

                        <h2 style="margin:0 0 0.5rem 0;font-size:1.5rem;display:flex;align-items:center;gap:0.5rem;">
                            <span>👤</span>
                            <span>Création de compte</span>
                        </h2>

                        <p class="muted" style="font-size:1.15rem;">
                            Avant de pouvoir te connecter en jeu, <strong>l’inscription est obligatoire</strong>.
                        </p>
                        <p class="muted" style="margin-top:0.45rem;font-size:1.15rem;">
                            Pour créer ton compte :
                        </p>
                        <ol class="muted" style="margin-left:1.2rem;margin-top:0.45rem;font-size:1.15rem;">
                            <li>
                                Clique sur la section <strong>« Inscription »</strong> dans le menu du site.
                            </li>
                            <li style="margin-top:0.4rem;">
                                Remplis le formulaire avec un <strong>identifiant</strong>, un <strong>mot de passe sécurisé</strong>  
                                et une <strong>adresse e-mail valide</strong>.
                            </li>
                            <li style="margin-top:0.4rem;">
                                Valide le formulaire : ton compte est alors créé et prêt à être utilisé en jeu.
                            </li>
                        </ol>

                        <p class="muted" style="margin-top:0.75rem;font-size:1.15rem;">
                            Ensuite, utilise ton <strong>identifiant</strong> et ton <strong>mot de passe</strong> directement dans le client  
                            pour te connecter sur <?= htmlspecialchars($SERVER_NAME) ?>.
                        </p>

                        <p class="muted" style="margin-top:0.6rem;font-size:1.15rem;">
                            <strong>Astuce :</strong> garde bien ton e-mail, il pourra servir à la récupération de compte en cas de problème.
                        </p>

                        <!-- BOUTON 2 : sans couleur + néon bleu au survol -->
                        <a href="inscription.php"
                           class="btn btn-primary guide-btn"
                           style="margin-top:0.7rem;padding:0.6rem 1.5rem;font-size:0.8rem;">
                            <span>aller à l’inscription</span>
                            <span style="font-size:1rem;">➜</span>
                        </a>
                    </div>

                    <!-- Bloc État des serveurs PRO -->
                    <div style="flex:0 0 auto;max-width:280px;">
                        <div style="
                            position:relative;
                            border-radius:0.9rem;
                            overflow:hidden;
                            background:#020617;
                            border:1px solid rgba(30,64,175,0.85);
                        ">
                            <!-- Fond image discret -->
                            <div style="
                                position:absolute;
                                inset:0;
                                background:url('assets/hf-city-1.jpg') center/cover no-repeat;
                                opacity:0.22;
                                filter:grayscale(100%);
                            "></div>
                            <!-- Voile sombre -->
                            <div style="
                                position:absolute;
                                inset:0;
                                background:linear-gradient(to bottom, rgba(15,23,42,0.9), rgba(15,23,42,0.98));
                            "></div>

                            <div style="position:relative;padding:0.9rem 1rem;font-size:0.95rem;">
                                <!-- En-tête -->
                                <div style="display:flex;justify-content:space-between;align-items:center;">
                                    <div style="display:flex;flex-direction:column;">
                                        <span style="font-size:0.8rem;text-transform:uppercase;letter-spacing:0.16em;opacity:0.85;">
                                            État des serveurs
                                        </span>
                                        <span style="font-size:0.95rem;font-weight:600;margin-top:0.15rem;">
                                            <?= htmlspecialchars($SERVER_NAME) ?>
                                        </span>
                                    </div>
                                    <div style="text-align:right;font-size:0.82rem;opacity:0.9;">
                                        <div>Version</div>
                                        <div style="font-weight:500;">High Five</div>
                                    </div>
                                </div>

                                <!-- Séparateur -->
                                <div style="margin:0.7rem 0;border-top:1px solid rgba(148,163,184,0.35);"></div>

                                <!-- Login / Game server -->
                                <div style="display:grid;row-gap:0.35rem;">
                                    <div style="display:flex;align-items:center;justify-content:space-between;">
                                        <div style="display:flex;align-items:center;gap:0.45rem;">
                                            <span style="
                                                width:9px;height:9px;border-radius:999px;
                                                background:#22c55e;
                                                box-shadow:0 0 6px rgba(34,197,94,0.9);
                                            "></span>
                                            <span style="font-weight:500;">Login server</span>
                                        </div>
                                        <span style="font-size:0.85rem;color:#bbf7d0;">En ligne</span>
                                    </div>
                                    <div style="display:flex;align-items:center;justify-content:space-between;">
                                        <div style="display:flex;align-items:center;gap:0.45rem;">
                                            <span style="
                                                width:9px;height:9px;border-radius:999px;
                                                background:#22c55e;
                                                box-shadow:0 0 6px rgba(34,197,94,0.9);
                                            "></span>
                                            <span style="font-weight:500;">Game server</span>
                                        </div>
                                        <span style="font-size:0.85rem;color:#bbf7d0;">En ligne</span>
                                    </div>
                                </div>

                                <!-- Bloc rates -->
                                <div style="
                                    margin-top:0.75rem;
                                    border-radius:0.6rem;
                                    background:rgba(15,23,42,0.96);
                                    border:1px solid rgba(51,65,85,0.9);
                                    padding:0.6rem 0.7rem;
                                    font-size:0.9rem;
                                ">
                                    <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:0.3rem;">
                                        <span style="font-size:0.8rem;text-transform:uppercase;letter-spacing:0.14em;opacity:0.85;">
                                            Rates
                                        </span>
                                    </div>
                                    <div style="display:grid;row-gap:0.2rem;">
                                        <div style="display:flex;justify-content:space-between;">
                                            <span>XP</span>
                                            <span><?= htmlspecialchars($serverRates['XP'] ?? 'x1') ?></span>
                                        </div>
                                        <div style="display:flex;justify-content:space-between;">
                                            <span>SP</span>
                                            <span><?= htmlspecialchars($serverRates['SP'] ?? 'x1') ?></span>
                                        </div>
                                        <div style="display:flex;justify-content:space-between;">
                                            <span>Adena</span>
                                            <span><?= htmlspecialchars($serverRates['ADENA'] ?? 'x1') ?></span>
                                        </div>
                                        <div style="display:flex;justify-content:space-between;">
                                            <span>Drop</span>
                                            <span><?= htmlspecialchars($serverRates['DROP'] ?? 'x1') ?></span>
                                        </div>
                                    </div>
                                </div>

                                <!-- Joueurs en ligne -->
                                <div style="margin-top:0.75rem;display:flex;justify-content:space-between;align-items:center;font-size:0.9rem;">
                                    <span>Joueurs en ligne</span>
                                    <span style="font-weight:650;">
                                        <?= $onlinePlayers !== null ? (int)$onlinePlayers : '—'; ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /Bloc état serveur -->
                </div> <!-- /flex -->
            </div>
        </div>
    </div>

</div>
<?php include 'includes/footer.php'; ?>


