<?php
// db.php
// Connexions PDO pour le panel Thanys

// ==========================
// CONFIG A ADAPTER CHEZ TOI
// ==========================

// Hôte/port MariaDB
const DB_HOST = '127.0.0.1';
const DB_PORT = 3306;

// Utilisateur / mot de passe MariaDB
const DB_USER = 'root';
const DB_PASS = 'Daniel78300.'; // change si besoin

// Nom des bases
const DB_LOGIN_NAME = 'l2srls';  // base loginserver
const DB_GAME_NAME  = 'l2srgs';  // base gameserver

/**
 * Retourne (et met en cache) un objet PDO vers la base donnée.
 *
 * @param string $dbName Nom de la base
 * @return PDO
 */
function thanys_get_pdo(string $dbName): PDO
{
    static $cache = [];

    if (isset($cache[$dbName])) {
        return $cache[$dbName];
    }

    $dsn = sprintf(
        'mysql:host=%s;port=%d;dbname=%s;charset=utf8mb4',
        DB_HOST,
        DB_PORT,
        $dbName
    );

    $options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
    ];

    try {
        $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
    } catch (PDOException $e) {
        // En prod tu peux commenter ce die() et regarder dans les logs
        if (PHP_SAPI !== 'cli') {
            header('Content-Type: text/plain; charset=utf-8');
        }
        die("Erreur de connexion à la base '{$dbName}': " . $e->getMessage());
    }

    $cache[$dbName] = $pdo;
    return $pdo;
}

/**
 * Connexion vers la base LOGIN (l2srls).
 */
function db_login(): PDO
{
    return thanys_get_pdo(DB_LOGIN_NAME);
}

/**
 * Connexion vers la base GAME (l2srgs).
 */
function db_game(): PDO
{
    return thanys_get_pdo(DB_GAME_NAME);
}

/**
 * Alias utilisé par certains scripts du panel (panel = même base que LOGIN).
 */
function db_panel(): PDO
{
    return db_login();
}
